<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Remote\Entity;

use FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface;
use FiloBlu\Refilo\Api\Data\ProductCustomOptionInterfaceFactory;
use FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface;
use FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterfaceFactory;

/**
 *
 */
class MagentoToRefiloProductOptionAdapter
{
    /**
     * @var \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterfaceFactory
     */
    private $customOptionFactory;
    /**
     * @var \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterfaceFactory
     */
    private $customOptionValueFactory;

    /**
     * @param \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterfaceFactory $customOptionFactory
     * @param \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterfaceFactory $customOptionValueFactory
     */
    public function __construct(
        ProductCustomOptionInterfaceFactory $customOptionFactory,
        ProductCustomOptionValueInterfaceFactory $customOptionValueFactory
    ) {
        $this->customOptionFactory = $customOptionFactory;
        $this->customOptionValueFactory = $customOptionValueFactory;
    }

    /**
     * @param \Magento\Catalog\Model\ResourceModel\Product\Option|\Magento\Catalog\Api\Data\ProductCustomOptionInterface $option
     * @return ProductCustomOptionInterface
     */
    public function adapt($option): ProductCustomOptionInterface
    {
        $values = [];
        foreach ($option->getValues() ?? [] as $value) {
            $values[] = $this->customOptionValueFactory->create([
                'data' => [
                    ProductCustomOptionValueInterface::ID    => (int)$value->getOptionTypeId(),
                    ProductCustomOptionValueInterface::SKU   => $value->getSku(),
                    ProductCustomOptionValueInterface::CODE  => $value->getTitle(),
                    ProductCustomOptionValueInterface::LABEL => $value->getTitle(),
                    ProductCustomOptionValueInterface::PRICE => $value->getPrice()
                ]
            ]);
        }

        return $this->customOptionFactory->create([
            'data' => [
                ProductCustomOptionInterface::ID              => (int)$option->getId(),
                ProductCustomOptionInterface::TYPE            => $option->getType(),
                ProductCustomOptionInterface::REQUIRED        => $option->getIsRequire(),
                ProductCustomOptionInterface::SKU             => $option->getSku(),
                ProductCustomOptionInterface::MAX_CHARACTERS  => $option->getMaxCharacters(),
                ProductCustomOptionInterface::CODE            => $option->getTitle(),
                ProductCustomOptionInterface::PRICE           => $option->getPrice(),
                ProductCustomOptionInterface::LABEL           => $option->getTitle(),
                ProductCustomOptionInterface::FILE_EXTENSIONS => $option->getFileExtension(),
                ProductCustomOptionInterface::IMAGE_SIZE_X    => $option->getImageSizeX(),
                ProductCustomOptionInterface::IMAGE_SIZE_Y    => $option->getImageSizeY(),
                ProductCustomOptionInterface::VALUES          => $values
            ]
        ]);
    }
}