<?php

namespace FiloBlu\Refilo\Plugins\Controller\Adminhtml\Wysiwyg\Images;

use Magento\Cms\Helper\Wysiwyg\Images;
use Magento\Framework\Controller\Result\RawFactory;

class ThumbnailPlugin
{
    protected $images;
    protected $rawFactory;

    public function __construct(
        Images $images,
        RawFactory $rawFactory
    )
    {
        $this->images = $images;
        $this->rawFactory = $rawFactory;
    }

    public function aroundExecute(\Magento\Cms\Controller\Adminhtml\Wysiwyg\Images\Thumbnail $subject, callable $proceed)
    {

        try {
            return $proceed();
        } catch (\Throwable $exception){
            $file = $subject->getRequest()->getParam('file');
            $file = $this->images->idDecode($file);
            $resultRaw = $this->rawFactory->create();
            $resultRaw->setHeader('Content-Type', 'image/svg+xml');
            $resultRaw->setContents(file_get_contents($subject->getStorage()->getSession()->getCurrentPath() . '/' . $file));
            return $resultRaw;
        }



    }
}
