<?php

namespace FiloBlu\Refilo\Model\Config\Source;

use Magento\Eav\Model\Entity\Attribute\Source\AbstractSource;

class SearchWeight extends AbstractSource
{
    /**
     * @return array
     */
    public function getAllOptions()
    {
        $this->_options = [];

        foreach ($this->getRange() as $weight) {
            $this->_options[] = [
                'label' => (string)$weight,
                'value' => $weight
            ];
        }

        return $this->_options;
    }

    /**
     * @return array
     */
    public function getRange(): array
    {
        return range(1, 10);
    }
}