<?php

namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Importer\Wishlist;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SomeCommand
 */
class ImportWishlist extends Command
{
    /**
     *
     */
    public const NAME = 'name';
    /**
     * @var Wishlist
     */
    private $wishlist;

    /**
     * @param \FiloBlu\Refilo\Model\Importer\Wishlist $wishlist
     * @param string|null $name
     */
    public function __construct(Wishlist $wishlist, string $name = null)
    {
        parent::__construct($name);
        $this->wishlist = $wishlist;
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME,
                null,
                InputOption::VALUE_REQUIRED,
                'Name'
            )
        ];

        $this->setName('refilo:sync:wishlist');
        $this->setDescription('Import Wishlist from Mongo');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     * @throws \Magento\Framework\Exception\AlreadyExistsException
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->wishlist->execute();
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
