/*eslint-disable */
define(["Magento_PageBuilder/js/config", "Magento_PageBuilder/js/utils/object"], function (_config, _object) {
    /**
     * Copyright © Magento, Inc. All rights reserved.
     * See COPYING.txt for license details.
     */

    /**
     * @api
     */
    var VideoSrc =
        /*#__PURE__*/
        function () {
            "use strict";

            function VideoSrc() {
            }

            var _proto = VideoSrc.prototype;

            /**
             * Convert value to internal format
             *
             * @param value string
             * @returns {string | object}
             */
            _proto.fromDom = function fromDom(value) {
                var result = "";

                if (value !== undefined && value !== "" && value !== null) {
                    var video = {
                        name: value.replace("video/",""),
                        size: 0,
                        type: "video/mp4",
                        url: _config.getConfig("media_url") + value
                    };
                    result = [video];
                }

                return result;
            }
            /**
             * Convert value to knockout format
             *
             * @param {string} name
             * @param {DataObject} data
             * @returns {string}
             */
            ;

            _proto.toDom = function toDom(name, data) {
                var value = (0, _object.get)(data, name);
                if (value[0] === undefined || value[0].name === undefined) {
                    return "";
                }

                var imageName = value[0].name;
                return "video/" + imageName;
            };

            return VideoSrc;
        }();

    return VideoSrc;
});
//# sourceMappingURL=src.js.map
