/*eslint-disable */
define(["Magento_PageBuilder/js/config", "Magento_PageBuilder/js/utils/image", "Magento_PageBuilder/js/utils/object", "Magento_PageBuilder/js/utils/url"], function (_config, _image, _object, _url) {
    /**
     * Copyright © Magento, Inc. All rights reserved.
     * See COPYING.txt for license details.
     */

    /**
     * @api
     */
    var Spacings =
        /*#__PURE__*/
        function () {
            "use strict";

            function Spacings() {
            }

            var _proto = Spacings.prototype;

            /**
             * Convert value to internal format
             *
             * @param value string
             * @returns {string | object}
             */
            _proto.fromDom = function fromDom(value) {

                if (!value) {
                    return "";
                }

                return {
                    mobileMargin: {
                        Top: value.mobileMarginTop,
                        Right: value.mobileMarginRight,
                        Bottom: value.mobileMarginBottom,
                        Left: value.mobileMarginLeft
                    },
                    mobilePadding: {
                        Top: value.mobilePaddingTop,
                        Right: value.mobilePaddingRight,
                        Bottom: value.mobilePaddingBottom,
                        Left: value.mobilePaddingLeft
                    }
                };
            }
            /**
             * Convert value to knockout format
             *
             * @param {string} name
             * @param {DataObject} data
             * @returns {string}
             */
            ;

            _proto.toDom = function toDom(name, data) {
                var value = (0, _object.get)(data, name);

                if (typeof value !== 'object' && toString(value) !== "[object Object]") {
                    return "";
                }
                var data = {
                    mobileMargin: {
                        Top: value.mobileMarginTop,
                        Right: value.mobileMarginRight,
                        Bottom: value.mobileMarginBottom,
                        Left: value.mobileMarginLeft
                    },
                    mobilePadding: {
                        Top: value.mobilePaddingTop,
                        Right: value.mobilePaddingRight,
                        Bottom: value.mobilePaddingBottom,
                        Left: value.mobilePaddingLeft
                    }
                }

                return data

            };

            return Spacings;
        }();

    return Spacings;
});
//# sourceMappingURL=src.js.map
