<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Model;

use FiloBlu\Refilo\Api\Data\GuestOrderRequestInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * @package FiloBlu\Refilo\Model
 * @class GuestOrderRequest
 */
class GuestOrderRequest extends AbstractModel implements GuestOrderRequestInterface
{
    /**
     * @return string
     */
    public function getCustomerEmail()
    {
        return $this->getData(self::CUSTOMER_EMAIL);
    }

    /**
     * @param string $email
     * @return $this|mixed
     */
    public function setCustomerEmail($email)
    {
        $this->setData(self::CUSTOMER_EMAIL, $email);
        return $this;
    }

    /**
     * @param string $incrementId
     * @return $this|mixed
     */
    public function setIncrementId($incrementId)
    {
        $this->setData(self::INCREMENT_ID, $incrementId);
        return $this;
    }

    /**
     * @return string
     */
    public function getIncrementId()
    {
        return $this->getData(self::INCREMENT_ID);
    }

    /**
     * @param int $storeId
     * @return $this|mixed
     */
    public function setStoreId($storeId)
    {
        $this->setData(self::STORE_ID, $storeId);
        return $this;
    }

    /**
     * @return int
     */
    public function getStoreId()
    {
        return $this->getData(self::STORE_ID);
    }
}
