<?php

namespace FiloBlu\Refilo\Helper;

use Magento\Framework\App\Helper\AbstractHelper;

class OrderCustomer extends AbstractHelper
{
    const XML_PATH_ORDER_SELECT_STRATEGY_ENABLED = 'refilo_sales/checkout/order_selection_strategy_enabled';
    const XML_PATH_ORDER_SELECTION_STRATEGY = 'refilo_sales/checkout/order_selection_strategy';

    /**
     * @return mixed
     */
    public function isOrderSelectionStrategyEnabled()
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_ORDER_SELECT_STRATEGY_ENABLED);
    }

    /**
     * @return mixed
     */
    public function getOrderSelectionStrategy()
    {
        return $this->scopeConfig->getValue(self::XML_PATH_ORDER_SELECTION_STRATEGY);
    }

    /**
     * @param $customerCreationDate
     * @return array|false
     */
    public function getOrderStrategyFilter($customerCreationDate)
    {
        $strategy = $this->getOrderSelectionStrategy();

        if ($strategy == 'all') {
            return false;
        }

        $timeToAdd = '-'. str_replace('_', ' ', $strategy);

        $startDate = date('Y-m-d H:i:s', strtotime($customerCreationDate . $timeToAdd));
        $endDate = date('Y-m-d H:i:s', strtotime($customerCreationDate));

        return [
            'from' => $startDate,
            'to' => $endDate
        ];
    }
}
