<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Api;

/**
 *
 */
interface WishlistManagementInterface
{
    /**
     * @param int $productId
     * @param int $customerId
     * @param mixed $attributeId
     * @param mixed $optionValue
     * @return mixed
     */
    public function saveProductToWishlist(int $productId, int $customerId, $attributeId = null, $optionValue = null);

    /**
     * @param int $productId
     * @param int $customerId
     * @param int $qty
     * @return mixed
     */
    public function updateProductQtyToWishlist(int $productId, int $customerId, int $qty);

    /**
     * @param int $productId
     * @param int $customerId
     * @return mixed
     */
    public function deleteProductFromWishlist(int $productId, int $customerId);

    /**
     * @param int $customerId
     * @return mixed
     */
    public function deleteAllProductFromWishlist(int $customerId);
}
