<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\SearchTerms;


use FiloBlu\Refilo\Model\Exporter\Search;
use Magento\Framework\Exception\LocalizedException;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 *
 */
class ExportTermsCommand extends Command
{
    /**
     * @var SearchTerms
     */
    private $searchTermsExporter;

    /**
     * ExportTermsCommand constructor.
     * @param SearchTerms $searchTermsExporter
     * @param string|null $name
     */
    public function __construct(SearchTerms $searchTermsExporter, string $name = null)
    {
        parent::__construct($name);
        $this->searchTermsExporter = $searchTermsExporter;
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     * @throws LocalizedException|\MongoDB\Driver\Exception\Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->searchTermsExporter->export($output);

        return 0;
    }

    /**
     *
     */
    protected function configure()
    {
        $this->setName('refilo:sync:search:terms')
            ->setDescription('Export Terms From Magento');
    }
}
