<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Api\Data;

/**
 *
 */
interface ProductCustomOptionInterface
{
    /** @var string  */
    public const ID = 'id';
    /** @var string  */

    public const TYPE = 'type';
    /** @var string  */

    public const REQUIRED = 'required';
    /** @var string  */

    public const SKU = 'sku';
    /** @var string  */

    public const MAX_CHARACTERS = 'max_characters';
    /** @var string  */

    public const CODE = 'code';
    /** @var string  */

    public const LABEL = 'label';
    /** @var string  */


    public const PRICE = 'price';
    /** @var string  */

    public const FILE_EXTENSIONS = 'file_extensions';
    /** @var string  */

    public const IMAGE_SIZE_Y = 'image_size_y';
    /** @var string  */

    public const IMAGE_SIZE_X = 'image_size_x';
    /** @var string  */

    public const VALUES = 'values';

    /**
     * @return int
     */
    public function getId(): int;

    /**
     * @return string
     */
    public function getType();

    /**
     * @return bool
     */
    public function getRequired() : bool;

    /**
     * @return string|null
     */
    public function getSku();

    /**
     * @return int
     */
    public function getMaxCharacters();

    /**
     * @return string|null
     */
    public function getCode();

    /**
     * @return mixed
     */
    public function getLabel();

    /**
     * @return float
     */
    public function getPrice() : float;

    /**
     * @return mixed
     */
    public function getFileExtensions();

    /**
     * @return int
     */
    public function getImageSizeX();

    /**
     * @return int
     */
    public function getImageSizeY();

    /**
     * @param string|int|null $id
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setId($id) : ProductCustomOptionInterface;

    /**
     * @param string $type
     * @return ProductCustomOptionInterface
     */
    public function setType(string $type) : ProductCustomOptionInterface;

    /**
     * @param bool $required
     * @return ProductCustomOptionInterface
     */
    public function setRequired(bool $required) : ProductCustomOptionInterface;

    /**
     * @param string|null $sku
     * @return ProductCustomOptionInterface
     */
    public function setSku(?string $sku)  : ProductCustomOptionInterface;

    /**
     * @param int $maxCharacters
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setMaxCharacters($maxCharacters)  : ProductCustomOptionInterface;

    /**
     * @param string $code
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setCode($code) : ProductCustomOptionInterface;

    /**
     * @param string|null $label
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setLabel(?string $label) : ProductCustomOptionInterface;

    /**
     * @param float $price
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setPrice(float $price) : ProductCustomOptionInterface;

    /**
     * @param array $fileExtensions
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setFileExtensions($fileExtensions) : ProductCustomOptionInterface;

    /**
     * @param int $imageSizeX
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setImageSizeX($imageSizeX) : ProductCustomOptionInterface;

    /**
     * @param int $imageSizeY
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setImageSizeY($imageSizeY) : ProductCustomOptionInterface;

    /**
     * @param \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface $value
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function addValue(ProductCustomOptionValueInterface $value) : ProductCustomOptionInterface;

    /**
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface[]
     */
    public function getValues();

    /**
     * @param \FiloBlu\Refilo\Api\Data\ProductCustomOptionValueInterface[] $values
     * @return \FiloBlu\Refilo\Api\Data\ProductCustomOptionInterface
     */
    public function setValues($values) : ProductCustomOptionInterface;

}