<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Api\Data;

/**
 * @interface OrderMappingInterface
 * @package FiloBlu\Refilo\Api\Data
 */
interface OrderMappingInterface
{
    /** @var string */
    const ENTITY_ID = 'entity_id';

    /** @var string */
    const CUSTOMER_ID = 'customer_id';

    /** @var string */
    const ORDER_ID = 'order_id';

    /** @var string  */
    const ORDER_STORE_ID = 'order_store_id';

    /**
     * @return mixed
     */
    public function getId();

    /**
     * @return mixed
     */
    public function getCustomerId();

    /**
     * @param $customerId
     * @return mixed
     */
    public function setCustomerId($customerId);

    /**
     * @return mixed
     */
    public function getOrderId();

    /**
     * @param $orderId
     * @return mixed
     */
    public function setOrderId($orderId);

    /**
     * @return mixed
     */
    public function getOrderStoreId();

    /**
     * @param $storeId
     * @return mixed
     */
    public function setOrderStoreId($storeId);
}
