<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Helper;

use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilderFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Store\Api\StoreRepositoryInterface;
use Magento\Store\Model\ScopeInterface;

/**
 * @class OrderMapping
 * @package FiloBlu\Refilo\Helper
 */
class OrderMappingHelper
{
    const XML_PATH_ORDER_DASHBOARD = 'refilo_sales/in_store_order_dashboard/enabled';

    /**
     * @var StoreRepositoryInterface
     */
    private $storeRepository;
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var CustomerRepositoryInterface
     */
    private $customerRepository;
    /**
     * @var SearchCriteriaBuilderFactory
     */
    private $searchCriteriaBuilderFactory;
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @param ScopeConfigInterface $scopeConfig
     * @param StoreRepositoryInterface $storeRepository
     * @param CustomerRepositoryInterface $customerRepository
     * @param SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory
     * @param ResourceConnection $resourceConnection
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        StoreRepositoryInterface $storeRepository,
        CustomerRepositoryInterface $customerRepository,
        SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory,
        ResourceConnection $resourceConnection
    ) {
        $this->storeRepository = $storeRepository;
        $this->scopeConfig = $scopeConfig;
        $this->customerRepository = $customerRepository;
        $this->searchCriteriaBuilderFactory = $searchCriteriaBuilderFactory;
        $this->resourceConnection = $resourceConnection;
    }

    /**
     * @return array
     */
    public function getEnabledStore()
    {
        $stores = $this->storeRepository->getList();

        $enabledStore = [];
        foreach ($stores as $store) {
            $enabled = $this->scopeConfig->getValue(
                self::XML_PATH_ORDER_DASHBOARD,
                ScopeInterface::SCOPE_STORE,
                $store->getCode()
            );

            if ($enabled === '1' && $store->getIsActive()) {
                $enabledStore[$store->getId()] = $store->getCode();
            }
        }

        return $enabledStore;
    }

    /**
     * @param $email
     * @return array
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getCustomerIdListByEmail($email): array
    {
        $searchCriteria = $this->searchCriteriaBuilderFactory->create()
            ->addFilter('email', $email)
            ->create();

        $customers = $this->customerRepository->getList($searchCriteria);

        $ids = [];
        foreach ($customers->getItems() as $customer) {
            $ids[$customer->getStoreId()] = $customer->getId();
        }

        return $ids;
    }
}
