<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Console\Command;

use Magento\Framework\DB\Adapter\AdapterInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class MappingCustomerOrderCommand
 * @package FiloBlu\Refilo\Console\Command
 */
class OrderMappingCommand extends Command
{
    /**
     * @var \FiloBlu\Refilo\Helper\OrderMappingHelper
     */
    private $orderMappingHelper;

    /**
     * @var \Magento\Framework\App\ResourceConnection
     */
    private $resourceConnection;

    /**
     * @param \FiloBlu\Refilo\Helper\OrderMappingHelper $orderMappingHelper
     * @param \Magento\Framework\App\ResourceConnection $resourceConnection
     * @param string|null $name
     */
    public function __construct(
        \FiloBlu\Refilo\Helper\OrderMappingHelper $orderMappingHelper,
        \Magento\Framework\App\ResourceConnection $resourceConnection,
        string $name = null
    ) {
        parent::__construct($name);
        $this->orderMappingHelper = $orderMappingHelper;
        $this->resourceConnection = $resourceConnection;
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $this->setName('refilo:order:mapping');
        $this->setDescription('Mapping customer-order');
        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $enabledStore = $this->orderMappingHelper->getEnabledStore();
        if (count($enabledStore) === 0) {
            return 0;
        }

        $connection = $this->resourceConnection->getConnection();
        $orderTable = $connection->getTableName('sales_order');
        $mappingTable = $connection->getTableName('filoblu_order_mapping');

        $connection->update($orderTable, ['is_in_store' => 1], "is_viewide_order = 1");

        $select = $connection->select()
            ->distinct()
            ->from(['so' => $orderTable], ['customer_email'])
            ->where('so.is_in_store = 1')
            ->where('so.store_id in (?)', array_keys($enabledStore));

        $emails = $connection->fetchCol($select);

        foreach ($emails as $email) {
            $select = $connection->select()
                ->from(['so' => $orderTable], ['customer_id', 'entity_id', 'store_id'])
                ->where('so.customer_email = ?', $email)
                ->where('so.customer_id is not null')
                ->where('so.store_id in (?)', array_keys($enabledStore));

            $query = $connection->insertFromSelect(
                $select,
                $connection->getTableName($mappingTable),
                ['customer_id', 'order_id', 'order_store_id'],
                AdapterInterface::INSERT_IGNORE
            );
            $connection->query($query);
        }

        return 0;
    }
}
