<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Remote\Entity\Provider\Filter;

use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Model\Product\Attribute\Source\Status as productStatus;
use Magento\Catalog\Model\Product\Visibility;
use Magento\Catalog\Model\ResourceModel\Product\Collection;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use Magento\Store\Api\Data\StoreInterface;

/**
 *
 */
class DisabledProductsFilter implements DisabledEntityFilterInterface
{

    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory
     */
    private $productCollectionFactory;

    /**
     * @param \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory
     */
    public function __construct(CollectionFactory $productCollectionFactory)
    {
        $this->productCollectionFactory = $productCollectionFactory;
    }

    /**
     * @param \Magento\Store\Api\Data\StoreInterface|null $store
     * @return array
     */
    public function getIds(StoreInterface $store = null): array
    {
        /** @var Collection $productCollection */
        $productCollection = $this->productCollectionFactory->create();

        return $productCollection->addStoreFilter($store)
            ->addAttributeToFilter(ProductInterface::STATUS, ['neq' => ProductStatus::STATUS_ENABLED])
            ->getAllIds() ?? [];
    }
}
