<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Model;

/**
 * Rounds num towards the nearest odd value when it is half way there, making 1.5 into 1 and 2.5 into 3.
 */
class RoundHalfOddStrategy implements RoundingStrategyInterface
{

    /**
     * @param $value
     * @param $decimals
     * @return float
     */
    public function round($value, $decimals)
    {
        return round($value, $decimals, PHP_ROUND_HALF_ODD);
    }
}