<?php

namespace FiloBlu\Refilo\Remote\Entity;

/**
 * Represent remote entity
 *
 * Interface EntityInterface
 * @package FiloBlu\Refilo\Remote
 */
interface EntityInterface
{
    /**
     * @return mixed
     */
    public function getId();

    /**
     * @param $id
     * @return EntityInterface
     */
    public function setId($id): EntityInterface;

    /**
     * Get object data by path
     *
     * Method consider the path as chain of keys: a/b/c => ['a']['b']['c']
     *
     * @param string $path
     * @return mixed
     */
    public function getDataByPath($path);
}
