<?php
namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\Countries;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SomeCommand
 */
class ImportCountries extends Command {
    const NAME = 'name';
    /**
     * @var Countries
     */
    private $countries;

    /**
     * ImportBlocks constructor.
     * @param Countries $countriesBlock
     * @param string $name
     */
    public function __construct(
        Countries $countriesBlock,
        string $name = null
    ) {
        $this->countries = $countriesBlock;
        parent::__construct($name);
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME,
                null,
                InputOption::VALUE_REQUIRED,
                'Name'
            )
        ];

        $this->setName('refilo:sync:countries');
        $this->setDescription('Import Geocountries');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->countries->export($output);
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
