<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\Redirects;

use FiloBlu\Refilo\Block\Adminhtml\Common\Button;

/**
 *
 */
class DeleteButton extends Button
{
    /**
     * @return array
     */
    public function getButtonData()
    {
        if ($this->getId() === null) {
            return [];
        }

        return [
            'label' => __('Delete'),
            'class' => 'delete action-secondary',
            'on_click' => 'deleteConfirm(\''
                . __('Are you sure you want to delete this event ?')
                . '\', \'' . $this->getUrl('*/*/delete', ['id' => $this->getId()]) . '\')',
            'sort_order' => 20,
        ];
    }

    /**
     * @return string
     */
    protected function getId()
    {
        return $this->context->getRequest()->getParam('id', null);
    }
}
