<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\ContentType\Edit\Tab;

use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Config\Model\Config\Source\Yesno;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Registry;

/**
 *
 */
class Refilo extends Generic implements TabInterface
{
    /**
     * @var Yesno
     */
    protected $yesNo;

    /**
     * Main constructor
     *
     * @param Context $context
     * @param Registry $registry
     * @param FormFactory $formFactory
     * @param Yesno $yesNo
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        Yesno $yesNo,
        array $data = []
    ) {
        $this->yesNo = $yesNo;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * Get tab label
     *
     * @return string
     */
    public function getTabLabel()
    {
        return __('Refilo');
    }

    /**
     * Get tab title
     *
     * @return string
     */
    public function getTabTitle()
    {
        return __('Refilo');
    }

    /**
     * Can show tab
     *
     * @return bool
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * Is tab hidden
     *
     * @return bool
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * {@inheritdoc}
     */
    protected function _prepareForm()
    {
        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create();
        $form->setHtmlIdPrefix('contenttype_');

        /** Information */

        $fieldset = $form->addFieldset('refilo_fieldset', ['legend' => __('Refilo')]);

        $fieldset->addField('refilo_layout', 'select', [
            'name'     => 'refilo_layout',
            'label'    => __('Refilo Layout'),
            'title'    => __('Refilo Layout'),
            'required' => false,
            'values'   => [
                ['value' => 'full-width', 'label' => 'Full Width'],
                ['value' => 'boxed', 'label' => 'Boxed'],
                ['value' => 'contained', 'label' => 'Contained']
            ]
        ]);

        $fieldset->addField('heading_visible', 'select', [
            'name'     => 'heading_visible',
            'label'    => __('Heading Visible'),
            'title'    => __('Heading Visible'),
            'required' => false,
            'values'   => $this->yesNo->toOptionArray()
        ]);

        $fieldset->addField('breadcrumbs_visible', 'select', [
            'name'     => 'breadcrumbs_visible',
            'label'    => __('Breadcrumbs Visible'),
            'title'    => __('Breadcrumbs Visible'),
            'required' => false,
            'values'   => $this->yesNo->toOptionArray()
        ]);

        $fieldset->addField('header_type', 'select', [
            'name'     => 'header_type',
            'label'    => __('Header Type'),
            'title'    => __('Header Type'),
            'required' => false,
            'values'   => [
                ['value' => 'filled', 'label' => 'Filled'],
                ['value' => 'transparent', 'label' => 'Transparent'],
                ['value' => 'custom_1', 'label' => 'Custom 1'],
                ['value' => 'custom_2', 'label' => 'Custom 2']
            ]
        ]);

        $fieldset->addField('css_class', 'text', [
            'name'     => 'css_class',
            'label'    => __('CSS Class'),
            'title'    => __('CSS Class'),
            'required' => false,
        ]);

        $fieldset->addField('css_style', 'textarea', [
            'name'     => 'css_style',
            'label'    => __('CSS Style'),
            'title'    => __('CSS Style'),
            'required' => false,
        ]);

        $this->_eventManager->dispatch(
            'adminhtml_block_contentmanager_contenttype_informations_prepareform', ['form' => $form]
        );

        $contentType = $this->_coreRegistry->registry('current_contenttype');
        if ($contentType) {
            $form->setValues($contentType->getData());
        }
        $this->setForm($form);

        return parent::_prepareForm();
    }
}
