<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Remote;

/**
 *
 */
class RunOnceDeleteItemFinder implements DeletedItemFinderInterface
{

    /**
     * @var array|null
     */
    private $deletedIds = null;
    /**
     * @var \FiloBlu\Refilo\Remote\DeletedItemFinderInterface
     */
    private $deletedItemFinder;

    /**
     * @param \FiloBlu\Refilo\Remote\DeletedItemFinderInterface $deletedItemFinder
     */
    public function __construct(DeletedItemFinderInterface $deletedItemFinder)
    {
        $this->deletedItemFinder = $deletedItemFinder;
    }

    /**
     * @return array
     */
    public function getDeletedIds(): array
    {
        if ($this->deletedIds === null) {
            $this->deletedIds = $this->deletedItemFinder->getDeletedIds();
            return $this->deletedIds;
        }

        return [];
    }
}