<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Plugins;

/**
 *
 */
class AddLabelField
{
    /**
     * @var \Magento\Framework\Registry
     */
    private $registry;

    /**
     * @param \Magento\Framework\Registry $registry
     */
    public function __construct(\Magento\Framework\Registry $registry)
    {
        $this->registry = $registry;
    }

    /**
     * @return void
     * @see \FiloBlu\Label\Block\Adminhtml\Coretranslate\Edit\Tab\General::setForm
     */
    public function beforeSetForm(\Magento\Backend\Block\Widget\Form $subject, \Magento\Framework\Data\Form $form)
    {
        $model = $this->registry->registry('label_coretranslate');

        $fieldset = $form->getElement('base_fieldset');

        $fieldset->addField(
            'is_frontend_label',
            'select',
            [
                'name'    => 'filoblu_labelmanager[is_frontend_label]',
                'label'   => __('Is frontend label'),
                'title'   => __('Is frontend label'),
                'options' => ['0' => 'No', '1' => 'Yes'],
            ]
        );

        $form->addValues(['is_frontend_label' => $model->getData('is_frontend_label')]);
        return [$form];
    }
}
