<?php

namespace FiloBlu\Refilo\Data\Remote;

use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationRepository;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class ConnectorConfigurationOptions
 * @package FiloBlu\Refilo\Data\Remote
 */
class ConnectorConfigurationOptions implements OptionSourceInterface
{
    /**
     * @var array
     */
    protected $options;
    /**
     * @var ConnectorConfigurationRepository
     */
    private $connectorRepository;

    /**
     * ConnectorConfigurationOptions constructor.
     * @param ConnectorConfigurationRepository $connectorRepository
     */
    public function __construct(ConnectorConfigurationRepository $connectorRepository)
    {
        $this->connectorRepository = $connectorRepository;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        if ($this->options !== null) {
            return $this->options;
        }

        $connectorConfigurations = $this->connectorRepository->getList();

        $this->options = [];

        foreach ($connectorConfigurations->getItems() as $connector) {
            $this->options[] = [
                'label' => $connector->getName(),
                'value' => $connector->getId()
            ];
        }
        return $this->options;
    }
}
