<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Remote;

use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Class UrlsIndexer
 * @package FiloBlu\Refilo\Remote
 */
class UrlsIndexer extends AbstractStoreBasedIndexer
{

    /**
     * @return string
     */
    protected function getClass(): string
    {
        return __CLASS__;
    }

    /**
     * @param $entities
     * @param $collection
     * @return mixed|void
     * @throws NoSuchEntityException
     */
    public function write($entities, $collection)
    {
        $this->getConnector()->create($entities, $collection);
    }

    /**
     *
     */
    public function executeFull()
    {
        $this->executeList($this->getIndexerHelper()->getChangeLogIds($this));
    }
}

