<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Remote\Entity;

/**
 * Class Category
 * @package FiloBlu\Refilo\Remote\Entity
 */
class Category extends AbstractEntity
{
    public const NAME = 'name';
    public const FULL_NAME = 'full_name';
    public const LEVEL = 'level';
    public const DESCRIPTION = 'description';
    public const POSITION = 'position';
    public const PARENT_ID = 'parent_id';
    public const CREATED_AT = 'created_at';
    public const UPDATED_AT = 'updated_at';
    public const META_KEYWORDS = 'meta_keywords';
    public const META_TITLE = 'meta_title';
    public const META_DESCRIPTION = 'meta_description';
    public const CHILDERN_COUNT = 'children_count';
    public const PERMISSIONS = 'permissions';
    public const META_ROBOTS = 'meta_robots';
    public const CATEGORY_SEO_NAME = 'category_seo_name';
    public const ENABLED = 'enabled';
    public const PATH = 'path';
    public const INCLUDE_IN_MENU = 'include_in_menu';
    public const HIDE_FILTERS = 'hide_filters';
    public const TILE_VARIANT = 'tile_variant';
    public const HIDE_SORT_BY = 'hide_sortby';
    public const HEADING_VARIANT = 'heading_variant';
    public const CATEGORY_IDENTIFIER = 'category_identifier';
    public const EXCLUDE_FROM_SEARCH = 'exclude_from_search';
    public const REFILO_TEMPLATE = 'refilo_template';
    public const IS_ANCHOR = 'is_anchor';
    public const IMAGE = 'image';
    public const MOBILE_IMAGE = 'mobile_image';
    public const CHILDREN = 'childs';
    public const ALL_CHILDREN = 'all_children';
    public const REFILO_VIEW_MODE_ENABLED = 'refilo_view_mode_enabled';
    public const REFILO_VIEW_MODE = 'refilo_view_mode';
    public const REFILO_SIBLINGS_CATEGORIES_ENABLED = 'refilo_siblings_categories_enabled';
    public const REFILO_CHILDREN_CATEGORIES_ENABLED = 'refilo_children_categories_enabled';
    public const EMOTIONAL_PRODUCTS = 'emotional_products';
    public const REFILO_SEARCH_WEIGHT = 'refilo_search_weight';

    /**
     * Product constructor.
     * @param array $data
     */
    public function __construct(array $data = [])
    {
        parent::__construct($data);
        $this->setData('docType', 'category');
    }

    /**
     * @param $position
     * @return $this
     */
    public function setPosition($position): Category
    {
        $this->setData(self::POSITION, $position);
        return $this;
    }

    /**
     * @param $parentId
     * @return $this
     */
    public function setParentId($parentId): Category
    {
        $this->setData(self::PARENT_ID, $parentId);
        return $this;
    }

    /**
     * @param $date
     * @return $this
     */
    public function setCreatedAt($date): Category
    {
        $this->setData(self::CREATED_AT, $date);
        return $this;
    }

    /**
     * @param $date
     * @return $this
     */
    public function setUpdatedAt($date): Category
    {
        $this->setData(self::UPDATED_AT, $date);
        return $this;
    }

    /**
     * @param $name
     * @return $this
     */
    public function setName($name): Category
    {
        $this->setData(self::NAME, $name);
        return $this;
    }

    /**
     * @param $name
     * @return $this
     */
    public function setFullName($name): Category
    {
        $this->setData(self::FULL_NAME, $name);
        return $this;
    }

    /**
     * @return array|mixed|null
     */
    public function getFullName()
    {
        return $this->getData(self::FULL_NAME);
    }

    /**
     * @param $level
     * @return $this
     */
    public function setLevel($level): Category
    {
        $this->setData(self::LEVEL, $level);
        return $this;
    }

    /**
     * @param $description
     * @return $this
     */
    public function setDescription($description): Category
    {
        $this->setData(self::DESCRIPTION, $description);
        return $this;
    }

    /**
     * @param $metaTitle
     * @return $this
     */
    public function setMetaTitle($metaTitle): Category
    {
        $this->setData(self::META_TITLE, $metaTitle);
        return $this;
    }

    /**
     * @param $metaKeywords
     * @return $this
     */
    public function setMetaKeywords($metaKeywords): Category
    {
        $this->setData(self::META_KEYWORDS, $metaKeywords);
        return $this;
    }

    /**
     * @param $metaDescription
     * @return $this
     */
    public function setMetaDescription($metaDescription): Category
    {
        $this->setData(self::META_DESCRIPTION, $metaDescription);
        return $this;
    }

    /**
     * @param $childrenCount
     * @return $this
     */
    public function setChildrenCount($childrenCount): Category
    {
        $this->setData(self::CHILDERN_COUNT, $childrenCount);
        return $this;
    }

    /**
     * @param $metaRobots
     * @return $this
     */
    public function setMetaRobots($metaRobots): Category
    {
        $this->setData(self::META_ROBOTS, $metaRobots);
        return $this;
    }

    /**
     * @param $permissions
     * @return $this
     */
    public function setPermissions($permissions): Category
    {
        $this->setData(self::PERMISSIONS, $permissions);
        return $this;
    }

    /**
     * @param $categorySeoName
     * @return $this
     */
    public function setCategorySeoName($categorySeoName): Category
    {
        $this->setData(self::CATEGORY_SEO_NAME, $categorySeoName);
        return $this;
    }

    /**
     * @param $enabled
     * @return $this
     */
    public function setEnabled($enabled): Category
    {
        $this->setData(self::ENABLED, $enabled);
        return $this;
    }

    /**
     * @param $includeInMenu
     * @return $this
     */
    public function setIncludeInMenu($includeInMenu): Category
    {
        $this->setData(self::INCLUDE_IN_MENU, $includeInMenu);
        return $this;
    }

    /**
     * @param $path
     * @return $this
     */
    public function setPath($path): Category
    {
        $this->setData(self::PATH, $path);
        return $this;
    }

    /**
     * @param $tileVariant
     * @return $this
     */
    public function setTileVariant($tileVariant): Category
    {
        $this->setData(self::TILE_VARIANT, $tileVariant);
        return $this;
    }

    /**
     * @param $hideFilters
     * @return $this
     */
    public function setHideFilters($hideFilters): Category
    {
        $this->setData(self::HIDE_FILTERS, $hideFilters);
        return $this;
    }

    /**
     * @param $hideSortby
     * @return $this
     */

    public function setHideSortby($hideSortby): Category
    {
        $this->setData(self::HIDE_SORT_BY, $hideSortby);
        return $this;
    }

    /**
     * @return $this
     */
    public function setHeadingVariant($headingVariant): Category
    {
        $this->setData(self::HEADING_VARIANT, $headingVariant);
        return $this;
    }

    /**
     * @return $this
     */
    public function setCategoryIdentifier($categoryIdentifier): Category
    {
        $this->setData(self::CATEGORY_IDENTIFIER, $categoryIdentifier);
        return $this;
    }

    /**
     * @param $excludeFromSearch
     * @return $this
     */
    public function setExcludeFromSearch($excludeFromSearch): Category
    {
        $this->setData(self::EXCLUDE_FROM_SEARCH, $excludeFromSearch);
        return $this;
    }

    /**
     * @param $template
     * @return $this
     */
    public function setRefiloTemplate($template): Category
    {
        $this->setData(self::REFILO_TEMPLATE, $template);
        return $this;
    }

    /**
     * @param $refiloViewModeEnabled
     * @return $this
     */
    public function setRefiloViewModeEnabled($refiloViewModeEnabled): Category
    {
        $this->setData(self::REFILO_VIEW_MODE_ENABLED, $refiloViewModeEnabled);
        return $this;
    }

    /**
     * @param $refiloViewMode
     * @return $this
     */
    public function setRefiloViewMode($refiloViewMode): Category
    {
        $this->setData(self::REFILO_VIEW_MODE, $refiloViewMode);
        return $this;
    }

    /**
     * @param $refiloSiblingsCategoriesEnabled
     * @return $this
     */
    public function setRefiloSiblingsCategoriesEnabled($refiloSiblingsCategoriesEnabled): Category
    {
        $this->setData(self::REFILO_SIBLINGS_CATEGORIES_ENABLED, $refiloSiblingsCategoriesEnabled);
        return $this;
    }

    /**
     * @param $refiloChildrenCategoriesEnabled
     * @return $this
     */
    public function setRefiloChildrenCategoriesEnabled($refiloChildrenCategoriesEnabled): Category
    {
        $this->setData(self::REFILO_CHILDREN_CATEGORIES_ENABLED, $refiloChildrenCategoriesEnabled);
        return $this;
    }

    /**
     * @param $isAnchor
     * @return $this
     */
    public function setIsAnchor($isAnchor): Category
    {
        $this->setData(self::IS_ANCHOR, $isAnchor);
        return $this;
    }

    /**
     * @param $image
     * @return $this
     */
    public function setImage($image): Category
    {
        $this->setData(self::IMAGE, $image);
        return $this;
    }

    /**
     * @param $image
     * @return $this
     */
    public function setMobileImage($image): Category
    {
        $this->setData(self::MOBILE_IMAGE, $image);
        return $this;
    }

    /**
     * @param $children
     * @return $this
     */
    public function setChildren($children): Category
    {
        $this->setData(self::CHILDREN, $children);
        return $this;
    }

    public function setAllChildren($children): Category
    {
        $this->setData(self::ALL_CHILDREN, $children);
        return $this;
    }

    /**
     * @param $permission
     * @return $this
     */
    public function addPermission($permission): Category
    {
        $permissions = $this->getData(self::PERMISSIONS) ?? [];
        $permissions[] = $permission;
        $this->setData(self::PERMISSIONS, $permissions);
        return $this;
    }

    /**
     * @return $this
     */
    public function setEmotionalProducts($emotionalProducts): Category
    {
        $this->setData(self::EMOTIONAL_PRODUCTS, $emotionalProducts);
        return $this;
    }

    /**
     * @return array|mixed|null
     */
    public function getRefiloSearchWeight()
    {
        return $this->getData(self::REFILO_SEARCH_WEIGHT);
    }

    /**
     * @param $refiloSearchWeight
     * @return $this
     */
    public function setRefiloSearchWeight($refiloSearchWeight): Category
    {
        $this->setData(self::REFILO_SEARCH_WEIGHT, $refiloSearchWeight);
        return $this;
    }
}
