<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Plugins\Model\Indexer;

use FiloBlu\Refilo\Model\Indexer\Locator\SnapshotMViewStateTableInterface;

class BeforeReindexAll
{
    /**
     * @var \FiloBlu\Refilo\Model\Indexer\Locator\SnapshotMViewStateTableInterface
     */
    private $snapShooter;

    /**
     * @param SnapshotMViewStateTableInterface $snapShooter
     */
    public function __construct(SnapshotMViewStateTableInterface $snapShooter)
    {
        $this->snapShooter = $snapShooter;
    }

    public function beforeReindexAll($subject)
    {
        // SnapShoot mview_state table to executeList of changelogs during full reindex
        $this->snapShooter->snapShoot();
    }
}
