<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Controller\Adminhtml\Indexer;

use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationInterface;
use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationRepositoryInterface;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterface;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Api\SearchCriteriaBuilderFactory;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Exception\NoSuchEntityException;


/**
 *
 */
class MassConnector extends Action
{

    /**
     * @var IndexerConfigurationRepositoryInterface
     */
    private $indexerConfigurationRepository;
    /**
     * @var SearchCriteriaBuilderFactory
     */
    private $searchCriteriaBuilderFactory;
    /**
     * @var ConnectorConfigurationRepositoryInterface
     */
    private $connectorConfigurationRepository;

    /**
     * @param Context $context
     * @param IndexerConfigurationRepositoryInterface $indexerConfigurationRepository
     * @param ConnectorConfigurationRepositoryInterface $connectorConfigurationRepository
     * @param SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory
     */
    public function __construct(
        Context                                   $context,
        IndexerConfigurationRepositoryInterface   $indexerConfigurationRepository,
        ConnectorConfigurationRepositoryInterface $connectorConfigurationRepository,
        SearchCriteriaBuilderFactory              $searchCriteriaBuilderFactory
    )
    {
        parent::__construct($context);
        $this->indexerConfigurationRepository = $indexerConfigurationRepository;
        $this->searchCriteriaBuilderFactory = $searchCriteriaBuilderFactory;
        $this->connectorConfigurationRepository = $connectorConfigurationRepository;
    }

    /**
     * Execute action based on request and return result
     *
     * @return ResultInterface|ResponseInterface
     * @throws NoSuchEntityException
     */
    public function execute()
    {
        $request = $this->getRequest();
        $excluded = $request->getParam('excluded');
        $selected = $request->getParam('selected');

        /** @var ConnectorConfigurationInterface $connectorConfiguration */
        $connectorConfiguration = $this->connectorConfigurationRepository->getById((int)$request->getParam('connector'));

        $searchCriteriaBuilder = $this->searchCriteriaBuilderFactory->create();

        if ($selected !== null) {
            $searchCriteriaBuilder->addFilter(IndexerConfigurationInterface::ID, $selected, 'in');
        }

        if ($excluded !== null) {
            $searchCriteriaBuilder->addFilter(IndexerConfigurationInterface::ID, $excluded, 'nin');
        }

        $result = $this->indexerConfigurationRepository->getList($searchCriteriaBuilder->create());

        /** @var IndexerConfigurationInterface $indexerConfiguration */
        foreach ($result->getItems() as $indexerConfiguration) {
            $indexerConfiguration->setConnectorConfiguration($connectorConfiguration);
            $this->indexerConfigurationRepository->save($indexerConfiguration);
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $resultRedirect->setPath('*/*/');
        return $resultRedirect;
    }

    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('FiloBlu_Refilo::Refilo');
    }
}
