<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\Exporter;

use Exception;
use FiloBlu\Refilo\Model\Exporter\CmsPage as CmsPageBlock;
use Magento\Framework\App\Action\HttpGetActionInterface as HttpGetActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Message\ManagerInterface;

class Cmspages implements HttpGetActionInterface
{
    /**
     * @var
     */
    private $messageManager;
    /**
     * @var ResultFactory
     */
    private $resultFactory;
    /**
     * @var CmsPageBlock
     */
    protected $cmsPageExporter;

    /**
     * Countries constructor.
     * @param ResultFactory $resultFactory
     * @param ManagerInterface $messageManager
     * @param CmsPageBlock $cmsPageExporter
     */
    public function __construct(
        ResultFactory $resultFactory,
        ManagerInterface $messageManager,
        CmsPageBlock $cmsPageExporter
    ) {
        $this->resultFactory = $resultFactory;
        $this->messageManager = $messageManager;
        $this->cmsPageExporter = $cmsPageExporter;
    }

    public function execute()
    {
        try {
            $this->cmsPageExporter->export();
            $this->messageManager->addSuccessMessage(__('CMS pages successfully synced with MongoDB'));
        } catch (Exception $e) {
            $this->messageManager->addExceptionMessage($e);
        }

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('indexer/indexer/list/');
    }
}
