<?php

namespace FiloBlu\Refilo\Controller\Adminhtml\Connector;

use Exception;
use FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationRepositoryInterface;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterface;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Api\SearchCriteriaBuilderFactory;
use Magento\Framework\Controller\ResultInterface;

/**
 *
 */
class Delete extends Action
{
    /**
     * @var \FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationRepositoryInterface
     */
    private $connectorConfigurationRepository;
    /**
     * @var \FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationRepositoryInterface
     */
    private $indexerConfigurationRepository;
    /**
     * @var \Magento\Framework\Api\SearchCriteriaBuilderFactory
     */
    private $searchCriteriaBuilderFactory;

    /**
     * Delete constructor.
     * @param Context $context
     * @param \FiloBlu\Refilo\Remote\Connector\ConnectorConfigurationRepositoryInterface $connectorConfigurationRepository
     * @param \FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationRepositoryInterface $indexerConfigurationRepository
     * @param \Magento\Framework\Api\SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory
     */
    public function __construct(
        Context $context,
        ConnectorConfigurationRepositoryInterface $connectorConfigurationRepository,
        IndexerConfigurationRepositoryInterface $indexerConfigurationRepository,
        SearchCriteriaBuilderFactory              $searchCriteriaBuilderFactory
    ) {
        parent::__construct($context);
        $this->connectorConfigurationRepository = $connectorConfigurationRepository;
        $this->indexerConfigurationRepository = $indexerConfigurationRepository;
        $this->searchCriteriaBuilderFactory = $searchCriteriaBuilderFactory;
    }

    /**
     * @return ResultInterface
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id');
        if ($id === null) {
            return $this->resultRedirectFactory->create()->setPath('*/*/');
        }

        try {
            $this->connectorConfigurationRepository->deleteById($id);
            $this->updateIndexerConfigurations($id);
            $this->messageManager->addSuccessMessage(__('Deleted configuration with id %1', $id));
        } catch (Exception $exception) {
            $this->messageManager->addExceptionMessage($exception);
        }

        return $this->resultRedirectFactory->create()->setPath('*/*/');
    }

    /**
     * @param $id
     * @return void
     */
    public function updateIndexerConfigurations($id)
    {
        $searchCriteriaBuilder = $this->searchCriteriaBuilderFactory->create();
        $searchCriteria = $searchCriteriaBuilder
            ->addFilter(IndexerConfigurationInterface::CONNECTOR_CONFIGURATION, $id)
            ->create();
        /** @var \FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterface $indexerConfiguration */
        foreach ($this->indexerConfigurationRepository->getList($searchCriteria)->getItems() as $indexerConfiguration) {
            $indexerConfiguration->setConnectorConfiguration(null);
            $this->indexerConfigurationRepository->save($indexerConfiguration);
        }
    }
}
