<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Api;

/**
 * Newsletter interface.
 * @api
 */
interface NewsletterManagementInterface
{

    /**
     * Subscribe an email.
     *
     * @param string $email
     * @param string $source
     * @param string $firstname
     * @param string $lastname
     * @param string $dob
     * @param string $gender
     * @param string $country
     * @param string $collections
     * @param string $phone
     * @param string $language
     * @param string $website_name
     * @return \FiloBlu\Refilo\Api\NewsletterSubscribeInterface
     */
    public function subscribe(
        $email,
        $source,
        $firstname = null,
        $lastname = null,
        $dob = null,
        $gender = null,
        $country = null,
        $collections = null,
        $phone = null,
        $language = null,
        $website_name = null
    );

}
