<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Remote;

use FiloBlu\Refilo\Remote\Entity\EntityProviderInterfaceFactory;
use FiloBlu\Refilo\Remote\Helper\TemplateStringFactory;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationRepositoryInterface;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerConfigurationInterfaceFactory;
use FiloBlu\Refilo\Remote\IndexerConfiguration\IndexerResolver;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DataObjectFactory;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;
/**
 * Class PriceIndexer
 * @package FiloBlu\Refilo\Remote
 */
//@todo check for empty bulk if extended from AbstractWebsiteBasedIndexer
class PriceIndexer extends AbstractStoreBasedIndexer
{
    /**
     * @param array $ids
     */
    public function beforeExecute(array $ids = [])
    {
        $this->getIndexerHelper()->fixPriceIndex();
    }

    /**
     * @return string
     */
    protected function getClass(): string
    {
        return __CLASS__;
    }
}

