<?php

namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Helper\Data;
use FiloBlu\Refilo\Model\Importer\Translation;
use Magento\Framework\Console\CommandListInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SyncTranslationCommand
 * @package FiloBlu\Refilo\Console\Command
 */
class SyncTranslationCommand extends Command
{
    /**
     * @var CommandListInterface[]
     */
    protected $commandList;

    /**
     * @var Translation
     */
    private $translation;

    /**
     * @var \FiloBlu\Refilo\Helper\Data
     */
    private $helperData;

    /**
     * @param \FiloBlu\Refilo\Model\Importer\Translation $translation
     * @param \FiloBlu\Refilo\Helper\Data $helperData
     * @param string|null $name
     */
    public function __construct(
        Translation         $translation,
        Data                $helperData,
        string              $name = null
    )
    {
        parent::__construct($name);
        $this->translation = $translation;
        $this->helperData = $helperData;
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $this->setName('refilo:translation:sync');
        $this->setDescription('Sync all syncable');
        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        foreach ($this->helperData->getLocales() as $locale) {
            $this->translation->import($locale);
        }

        return 0;
    }

}
