<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\Indexer;

use FiloBlu\Refilo\Block\Adminhtml\Common\Button;

/**
 *
 */
class ConnectorsButton extends Button
{
    /**
     * @inheritDoc
     */
    public function getButtonData()
    {
        return [
            'label' => __('Configure Connectors'),
            'class' => 'primary',
            'on_click' => sprintf("location.href = '%s';", $this->getUrl('filoblu_refilo/connector/index')),
            'sort_order' => 10
        ];
    }
}
