<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\Form\Field;

use Magento\Framework\View\Element\AbstractBlock;

/**
 *
 */
class TextColumn extends AbstractBlock
{

    /**
     * Set "name" for <select> element
     *
     * @param string $value
     * @return $this
     */
    public function setInputName($value)
    {
        return $this->setName($value);
    }

    /**
     * Set "id" for <select> element
     *
     * @param $value
     * @return $this
     */
    public function setInputId($value)
    {
        return $this->setId($value);
    }

    /**
     * Render html output
     *
     * @return string
     */
    protected function _toHtml()
    {
        if (!$this->_beforeToHtml()) {
            return '';
        }

        $html = '<input type="text" name="' . $this->getName() . '" id="' . $this->getId() . '" ';
        $html .= 'value="' . $this->escapeHtml($this->getValue()) . '" ';
        $html .= 'class="' . $this->getClass() . '" readonly style="color: black; border: 0; opacity: 1; background: none"/> ';

        return $html;
    }
}
