<?php

namespace FiloBlu\Refilo\Remote\Entity;

/**
 * Class Product
 * TODO:
 *       image alt
 *       meta
 *       - related  in prodotto +
 *       - upsell
 *       - crossell
 *
 * @package FiloBlu\Refilo\Remote\Entity
 * @method setSku($sku)
 * @method getSku
 * @method getType
 * @method setType($type)
 * @method getName
 * @method setName($name)
 * @method setCreatedAt($createdAt)
 * @method getCreatedAt
 * @method setUpdatedAt
 * @method setWeight($weight)
 * @method setVariants(array $variants)
 * @method setBundle($bundle)
 * @method setVisibile(string $string)
 * @method getInventory()
 */
class Product extends AbstractEntity
{
    const SKU = 'sku';
    const NAME = 'name';
    const TYPE = 'type';
    const ASSETS = 'assets';
    const VISIBLE = 'visible';
    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    const INVENTORY = 'inventory';
    const RATING = 'rating';
    const ATTRIBUTES = 'attributes';
    const WEIGHT = 'weight';
    const META_TITLE = 'meta_title';
    const META_KEYWORDS = 'meta_keywords';
    const META_DESCRIPTION = 'meta_description';
    const FILTERS = 'filters';
    const SORTABLES = 'sortables';
    const UPSELL = 'upsells';
    const CROSSSELL = 'crosssells';
    const RELATED = 'related';
    const ENABLED = 'enabled';
    const DOCTYPE = 'docType';
    const DOCTYPE_SPEC_ENABLED = ['all', 'product'];
    const DOCTYPE_SPEC_DISABLED = ['all'];
    const SEARCH_VISIBILITY = 'search_visibility';
    const CUSTOM_OPTIONS = 'custom_options';
    const CATEGORIES = 'categories';
    const IS_SALABLE = 'is_salable';
    const HIDE_PRICE = 'hide_price';
    const MIDDLE_PRICE = 'middle_price';
    const OLD_PRICE = 'old_price';
    const MIN_QTY = 'min_qty';
    const MAX_QTY = 'max_qty';
    const STEP = 'step';
    const CATEGORY_NAMES = 'category_names';

    /**
     * Product constructor.
     * @param array $data
     */
    public function __construct(array $data = [])
    {
        parent::__construct($data);
    }

    /**
     * @param array $children
     * @return $this
     */
    public function setChildren(array $children)
    {
        $this->setData('childs', $children);
        return $this;
    }

    /**
     * @param string $attributeCode
     * @param array $info
     * @return $this
     */
    public function addFilter(string $attributeCode, array $info)
    {
        $filters = $this->getData(self::FILTERS) ?? [];
        $filters[$attributeCode] = $info;
        $this->addData([self::FILTERS => $filters]);
        return $this;
    }

    /**
     * @param string $visibility
     * @return $this
     */
    public function setSearchVisibility(string $visibility)
    {
        $this->setData(self::SEARCH_VISIBILITY, $visibility);
        return $this;
    }

}
