<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Remote\Connector;

/**
 * Class NullConnector
 * @package FiloBlu\Refilo\Remote\Connector
 */
class NullConnector extends AbstractConnector {

    /**
     * @return mixed|void
     */
    public function disconnect(): ConnectorInterface
    {
        return $this;
    }

    /**
     * @param iterable $entities
     * @param string $collection
     * @return void
     */
    public function create(iterable $entities, string $collection) {}

    /**
     * @return ConnectorInterface
     */
    public function connect(): ConnectorInterface
    {
        return $this;
    }

    /**
     * @param array $entities
     * @param string $collection
     * @return void
     */
    public function delete(iterable $entities, string $collection) {}

    /**
     * @param iterable $entities
     * @param string $collection
     * @return void
     */
    public function update(iterable $entities, string $collection) {}

}
