<?php

namespace FiloBlu\Refilo\Model\Config\Source;

use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;

/**
 * @api
 * @since 100.0.2
 */
class Category implements \Magento\Framework\Data\OptionSourceInterface
{
    /**
     * @var array
     */
    protected $options;
    /**
     * @var CollectionFactory
     */
    protected $categoryCollectionFactory;

    /**
     * @param CollectionFactory $groupCollectionFactory
     */
    public function __construct(CollectionFactory $categoryCollectionFactory)
    {
        $this->categoryCollectionFactory = $categoryCollectionFactory;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->options) {
            $categoryCollection = $this->categoryCollectionFactory->create();
            $categoryCollection->addAttributeToSelect('name');
            $this->options = $categoryCollection->toOptionArray();
        }
        return $this->options;
    }
}
