<?php

namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\Urls;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SomeCommand
 */
class ImportUrls extends Command
{
    /**
     * @var string
     */
    const NAME = 'name';
    /**
     * @var Urls
     */
    private $urls;

    /**
     * ImportBlocks constructor.
     * @param Urls $urlBlock
     * @param string|null $name
     */
    public function __construct(
        Urls $urlBlock,
        string $name = null
    ) {
        $this->urls = $urlBlock;
        parent::__construct($name);
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME,
                null,
                InputOption::VALUE_REQUIRED,
                'Name'
            )
        ];

        $this->setName('refilo:sync:urls');
        $this->setDescription('Import Urls');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \MongoDB\Driver\Exception\Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->urls->export($output);
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
