<?php

namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\Storelocator;
use Magento\Framework\Exception\LocalizedException;
use MongoDB\Driver\Exception\Exception;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SomeCommand
 */
class ImportStores extends Command
{
    public const NAME = 'name';

    /**
     * @var Storelocator
     */
    private $storelocator;

    /**
     * ImportBlocks constructor.
     * @param Storelocator $storelocatorBlock
     * @param string $name
     */
    public function __construct(
        Storelocator $storelocatorBlock,
        string       $name = null
    )
    {
        $this->storelocator = $storelocatorBlock;
        parent::__construct($name);
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME,
                null,
                InputOption::VALUE_REQUIRED,
                'Name'
            )
        ];

        $this->setName('refilo:sync:store-locator');
        $this->setDescription('Import StoreLocator');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     * @throws LocalizedException
     * @throws Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->storelocator->export($output);
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
