<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Plugins;

/**
 *
 */
class AddressAddCareOfLabel
{

    /**
     * @param \Magento\Sales\Api\Data\OrderAddressInterface $address
     * @param \Magento\Sales\Api\Data\OrderAddressExtensionInterface|null $extensionAttributes
     * @return \Magento\Sales\Api\Data\OrderAddressExtensionInterface
     * @see \Magento\Sales\Api\Data\OrderAddressInterface::getExtensionAttributes()
     */
    public function afterGetExtensionAttributes(
        \Magento\Sales\Api\Data\OrderAddressInterface $address,
        $extensionAttributes
    ) {
        if($extensionAttributes && $address->getData('care_of')){
            $careOf = $address->getData('care_of');
            $extensionAttributes
                ->setCareOf($careOf)
            ;
        }

        return $extensionAttributes;
    }


}