<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Test\Benchmark;

use FiloBlu\Refilo\Remote\Entity\Provider\EntityUrlProvider;
use FiloBlu\Refilo\Remote\Entity\Provider\Filter\DisabledProductsFilter;
use FiloBlu\Refilo\Remote\Entity\Provider\Filter\EmptyDisabledEntityFilter;
use FiloBlu\Refilo\Remote\Entity\Provider\ProductUrlProvider;
use FiloBlu\Refilo\Remote\Entity\VoidEntityProviderReaderHandler;
use Magento\Framework\App\Bootstrap;
use Magento\Framework\DataObject;
use Magento\Store\Model\StoreManagerInterface;
use PhpBench\Benchmark\Metadata\Annotations\Subject;

require __DIR__ . '/../../../../../app/bootstrap.php';

/**
 * XDEBUG_MODE=off php ./vendor/bin/phpbench run ./vendor/filoblu/mod2-refilo/Test/Benchmark/ExportUrlConsumerBench.php --report=default
 */
final class ExportUrlCBench
{
    /** @var  \Magento\Framework\ObjectManagerInterface */
    private $objectManager;

    /**
     * @return \Magento\Framework\ObjectManagerInterface
     */
    public function getObjectManager()
    {
        if($this->objectManager) {
            return $this->objectManager;
        }

        $params = $_SERVER;
        $bootstrap = Bootstrap::create(BP, $params);
        $this->objectManager = $bootstrap->getObjectManager();

        return $this->objectManager;
    }

    /**
     * @Subject
     * @return void
     */
    public function benchUrlProviderFull()
    {


        $objectManager = $this->getObjectManager();

        /** @var   $provider */
        $provider = $objectManager->create(EntityUrlProvider::class, [
            'type' => 'product',
            'disabledEntityFilter' => $objectManager->create(EmptyDisabledEntityFilter::class)
        ]);

        /** @var StoreManagerInterface $storeManager */
        $storeManager = $objectManager->get(StoreManagerInterface::class);

        /** @var \FiloBlu\Refilo\Remote\Entity\VoidEntityProviderReaderHandler $reader */
        $reader = $objectManager->create(VoidEntityProviderReaderHandler::class);

        $store = $storeManager->getDefaultStoreView();
        $arguments = $objectManager->create(DataObject::class);
        $provider->forStore($store)->attachReaderHandler($reader, $arguments);
        iterator_to_array($provider);
        $provider->detachReaderHandler();
    }
    /**
     * @Subject
     * @return void
     */
    public function benchUrlProviderDisabled()
    {
        $objectManager = $this->getObjectManager();

        /** @var   $provider */
        $provider = $objectManager->create(EntityUrlProvider::class, [
            'type' => 'product',
            'disabledEntityFilter' => $objectManager->create(DisabledProductsFilter::class)
        ]);

        /** @var StoreManagerInterface $storeManager */
        $storeManager = $objectManager->get(StoreManagerInterface::class);

        /** @var \FiloBlu\Refilo\Remote\Entity\VoidEntityProviderReaderHandler $reader */
        $reader = $objectManager->create(VoidEntityProviderReaderHandler::class);

        $store = $storeManager->getDefaultStoreView();
        $arguments = $objectManager->create(DataObject::class);
        $provider->forStore($store)->attachReaderHandler($reader, $arguments);
        iterator_to_array($provider);
        $provider->detachReaderHandler();
    }
}