<?php
declare(strict_types=1);

namespace FiloBlu\Refilo\Block\Adminhtml\Search;

use Magento\Backend\Block\Widget\Container;

/**
 * Class RefiloExport
 * @package FiloBlu\Refilo\Block\Adminhtml\Search
 */
class RefiloExport extends Container
{
    /**
     * @return RefiloExport
     */
    protected function _prepareLayout()
    {

        $this->buttonList->add(
            'filoblu_refilo_search_export', [
                'id'      => 'filoblu_refilo_search_export',
                'label'   => __('Export'),
                'onclick' => sprintf("setLocation('%s')",
                    $this->getUrl('filoblu_refilo/exporter/search', ['_nosid' => true])
                )
            ]
        );
        return parent::_prepareLayout();
    }

}
