<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Remote\Entity\Provider;

use FiloBlu\Refilo\Helper\Url;
use FiloBlu\Refilo\Remote\Entity\AbstractEntity;
use FiloBlu\Refilo\Remote\Entity\Provider\Filter\DisabledEntityFilterInterface;
use FiloBlu\Refilo\Remote\Entity\UrlRewrite;
use FiloBlu\Refilo\Remote\Entity\UrlRewriteFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DB\Select;

/**
 * Class EntityUrlProvider
 * @package FiloBlu\Refilo\Remote\Entity\Provider
 */
class EntityUrlProvider extends AbstractUrlProvider
{
    /**
     * @var string
     */
    private $type;

    /**
     * @param ResourceConnection $resourceConnection
     * @param ScopeConfigInterface $scopeConfig
     * @param Url $urlHelper
     * @param UrlRewriteFactory $urlRewriteFactory
     * @param DisabledEntityFilterInterface $disabledEntityFilter
     * @param string $type
     */
    public function __construct(
        ResourceConnection $resourceConnection,
        ScopeConfigInterface $scopeConfig,
        Url $urlHelper,
        UrlRewriteFactory $urlRewriteFactory,
        DisabledEntityFilterInterface $disabledEntityFilter,
        string $type
    ) {
        parent::__construct($resourceConnection, $scopeConfig, $urlHelper, $urlRewriteFactory, $disabledEntityFilter);
        $this->type = $type;
    }

    /**
     * @return Select
     */
    public function getSelect(): Select
    {
        $connection = $this->getResourceConnection()->getConnection();
        $urlRewriteTable = $connection->getTableName('url_rewrite');
        $storeTable = $connection->getTableName('store');

        $storeCondition = '!=0';

        if ($this->hasStore()) {
            $storeId = $this->getStore()->getId();
            $storeCondition = "= $storeId";
        }

        $disabledEntityIds = $this->getDisabledEntityFilter()->getIds($this->getStore());

        $select = $connection->select()->from(
            [
                'u' => $urlRewriteTable
            ], [
                AbstractEntity::ID => 'u.url_rewrite_id',
                UrlRewrite::URL_ID => 'u.url_rewrite_id',
                UrlRewrite::IS_REDIRECT => 'u.redirect_type',
                UrlRewrite::TYPE => 'u.entity_type',
                UrlRewrite::ENTITY_ID => 'u.entity_id',
                UrlRewrite::URL => 'u.request_path',
                UrlRewrite::TARGET_URL => 'u.target_path'
            ]
        )->joinInner(
            [
                's' => $storeTable
            ], "s.store_id = u.store_id AND u.store_id $storeCondition AND entity_type = '$this->type'", [
                UrlRewrite::STORE => 's.code'
            ]
        );

        if (!empty($this->ids)) {
            $select->where(
                'u.url_rewrite_id IN (?)',
                $this->ids
            );
        }

        if (!empty($disabledEntityIds)) {
            $select->where('u.entity_id NOT IN (?)', $disabledEntityIds);
        }

        $select->order('u.target_path ASC');

        return $select;
    }
}
