<?php

namespace FiloBlu\Refilo\Console\Command;

use FiloBlu\Refilo\Model\Exporter\ExporterInterface;
use FiloBlu\Refilo\Model\Exporter\Storelocator;
use FiloBlu\Refilo\Model\Exporter\Synonyms;
use Magento\Framework\Exception\LocalizedException;
use MongoDB\Driver\Exception\Exception;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SomeCommand
 */
class ImportSynonyms extends Command
{
    const NAME = 'name';
    /**
     * @var \FiloBlu\Refilo\Model\Exporter\Synonyms
     */
    private $exporter;


    /**
     * @param \FiloBlu\Refilo\Model\Exporter\ExporterInterface $exporter
     * @param string|null $name
     */
    public function __construct(
        ExporterInterface $exporter,
        string $name = null
    ) {
        parent::__construct($name);
        $this->exporter = $exporter;
    }

    /**
     * @inheritDoc
     */
    protected function configure()
    {
        $options = [
            new InputOption(
                self::NAME, null, InputOption::VALUE_REQUIRED, 'Name'
            )
        ];

        $this->setName('refilo:sync:synonyms');
        $this->setDescription('Export Synonyms');
        $this->setDefinition($options);

        parent::configure();
    }

    /**
     * Execute the command
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int
     * @throws LocalizedException
     * @throws Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->exporter->export($output);
        $output->writeln('<info>Success.</info>');

        return 0;
    }
}
