<?php

namespace FiloBlu\Refilo\Model\Redirects;

use FiloBlu\Refilo\Model\Redirects\Interfaces\RedirectInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Redirects
 * @package FiloBlu\Refilo\Model\Redirects
 */
class Redirects implements RedirectInterface
{
    /**
     * @var
     */
    const CACHE_TAG = 'filoblu_refilo_redirects';

    /**
     * @var string
     */
    protected $_cacheTag = 'filoblu_refilo_redirects';

    /**
     * @var string
     */
    protected $_eventPrefix = 'filoblu_refilo_redirects';

    /**
     * @var string
     */
    public $host;

    /**
     * @var string
     */
    public $request_url;

    /**
     * @var string
     */
    public $target_url;

    /**
     * @var int
     */
    public $redirect_code;

    /**
     * @var
     */
    protected $id;

    /**
     * @return string[]
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @param string $host
     * @return RedirectInterface
     */
    public function setHost(string $host) : RedirectInterface
    {
        $this->host = $host;
        return $this;
    }

    /**
     * @param string $requestUrl
     * @return RedirectInterface
     */
    public function setRequestUrl(string $requestUrl) : RedirectInterface
    {
        $this->request_url = $requestUrl;
        return $this;
    }

    /**
     * @param string $targetUrl
     * @return RedirectInterface
     */
    public function setTargetUrl(string $targetUrl) : RedirectInterface
    {
        $this->target_url = $targetUrl;
        return $this;
    }

    /**
     * @param string $redirectCode
     * @return RedirectInterface
     */
    public function setRedirectCode(string $redirectCode) : RedirectInterface
    {
        $this->redirect_code = (int)$redirectCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * @return string
     */
    public function getRequestUrl()
    {
        return $this->request_url;
    }

    /**
     * @return string
     */
    public function getTargetUrl()
    {
        return $this->target_url;
    }

    /**
     * @return int
     */
    public function getRedirectCode()
    {
        return $this->redirect_code;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param $id
     * @return RedirectInterface
     */
    public function setId($id): RedirectInterface
    {
        $this->id = $id;
        return $this;
    }
}
