<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model\Exporter;

use Magento\Search\Model\QueryInterface;

class DefaultSearchTermExportStrategy implements SearchTermExportableInterface
{
    /**
     * @param \Magento\Search\Model\QueryInterface|\Magento\Search\Model\Query $query
     * @return bool
     */
    public function canExport(QueryInterface $query): bool
    {
        if (!$query->getIsActive()) {
            return false;
        }

        if (!empty($query->getRedirect())) {
            return true;
        }

        return false;
    }
}