<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Model\Config\Seo;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Api\Data\StoreInterface;
use Magento\Store\Model\ScopeInterface;

/**
 *
 */
class DefaultHrefLangConfiguration implements HrefLangConfigurationSourceInterface
{
    /**
     * @var string
     */
    public const XML_REFILO_CONTENT_GENERAL_ENABLE_HREFLANG_HOME = 'refilo_content/general/enable_hreflang_home';

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @param int|string|StoreInterface|Store $store
     * @return bool
     */
    public function isEnabledForCategory($store = 0): bool
    {
        return false;
    }

    /**
     * @param int|string|StoreInterface|Store $store
     * @return bool
     */
    public function isEnabledForProduct($store = 0): bool
    {
        return false;
    }

    /**
     * @param int|string|StoreInterface|Store $store
     * @return bool
     */
    public function isEnabledForCms($store = 0): bool
    {
        return false;
    }

    /**
     * @param $store
     * @return bool
     */
    public function isEnabledForHome($store = 0): bool
    {
        return $this->scopeConfig->isSetFlag(
            self::XML_REFILO_CONTENT_GENERAL_ENABLE_HREFLANG_HOME,
            ScopeInterface::SCOPE_STORE,
            $store
        );
    }

    /**
     * @param $store
     * @return bool
     */
    public function getLanguageCode($store = 0)
    {
        return '';
    }

    /**
     * @param $store
     * @return bool
     */
    public function usesCanonical($store = 0): bool
    {
       return false;
    }

    /**
     * @param $storeCode
     * @return string
     */
    public function getCanonicalStore($storeCode)
    {
       return '';
    }
}
