<?php

namespace FiloBlu\Refilo\Remote\Connector;

/**
 * Class FileConnector
 * @package FiloBlu\Refilo\Remote\Connector
 */
class FileConnector extends AbstractConnector
{
    /**
     * @var string|null
     */
    protected $filename;

    /**
     * @return mixed|void
     */
    public function disconnect(): ConnectorInterface
    {
        return $this;
    }

    /**
     * @param iterable $entities
     * @param string $collection
     * @return void
     */
    public function create(iterable $entities, string $collection)
    {
        $this->getUri();
        file_put_contents($this->filename, json_encode(iterator_to_array($entities), JSON_PRETTY_PRINT));
    }

    /**
     * https://tools.ietf.org/html/rfc3986
     * scheme://[username:password@]host1[:port1][,host2[:port2],...[,hostN[:portN]]][/[database][?options]]
     */
    protected function getUri(): string
    {
        $hosts = $this->getConfiguration()->getData(self::CONFIGURATION_HOST_POOL);

        $host = array_shift($hosts);
        $this->filename = $host['path'];

        return '';
    }

    /**
     * @return mixed|Manager
     */
    public function connect(): ConnectorInterface
    {
        $this->getUri();
        return $this;
    }

    /**
     * @param array $entities
     * @param string $collection
     * @return mixed|void
     */
    public function delete(iterable $entities, string $collection)
    {

    }

    /**
     * @param iterable $entities
     * @param string $collection
     * @return mixed|void
     */
    public function update(iterable $entities, string $collection)
    {
        $this->getUri();
        file_put_contents($this->filename, json_encode(iterator_to_array($entities), JSON_PRETTY_PRINT), FILE_APPEND);
    }
}
