<?php

declare(strict_types=1);

namespace FiloBlu\Refilo\Plugins\Model\ResourceModel\Eav;

use Magento\Catalog\Model\ResourceModel\Eav\Attribute;
use Magento\Framework\App\Config\ScopeConfigInterface;

/**
 *
 */
class AddCategoryDefaultSettings
{
    /** @var string */
    public const  XML_REFILO_CATALOG_CATEGORIES_REFILO_CHILDREN_CATEGORIES_DEFAULT = 'refilo_catalog/categories/refilo_children_categories_default';

    /** @var string */
    public const  XML_REFILO_CATALOG_SIBLINGS_REFILO_CHILDREN_CATEGORIES_DEFAULT = 'refilo_catalog/categories/refilo_siblings_categories_default';

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @param \Magento\Catalog\Model\ResourceModel\Eav\Attribute $model
     * @param $result
     * @return bool|mixed
     */
    public function afterGetDefaultValue(Attribute $model, $result)
    {
        if ($model->getAttributeCode() === 'refilo_children_categories_enabled') {
            return $this->getScopeConfig()->isSetFlag(
                self::XML_REFILO_CATALOG_CATEGORIES_REFILO_CHILDREN_CATEGORIES_DEFAULT
            ) ? '1' : '0';
        }

        if ($model->getAttributeCode() === 'refilo_siblings_categories_enabled') {
            return $this->getScopeConfig()->isSetFlag(
                self::XML_REFILO_CATALOG_SIBLINGS_REFILO_CHILDREN_CATEGORIES_DEFAULT
            )? '1' : '0';
        }

        return $result;
    }

    /**
     * @return \Magento\Framework\App\Config\ScopeConfigInterface
     */
    public function getScopeConfig(): ScopeConfigInterface
    {
        return $this->scopeConfig;
    }
}
