<?php

namespace FiloBlu\Refilo\Plugins;

use Magento\Cms\Controller\Adminhtml\Block\Save;

class CmsBlockPostValue
{

    /**
     * @param Save $subject
     * @return null
     */
    public function beforeExecute(Save $subject)
    {
        $displayOn = $subject->getRequest()->getPostValue('display_on', null);

        if ($displayOn === null) {
            return null;
        }

        $data = $subject->getRequest()->getPostValue("{$displayOn}_selection", '');
        if (is_array($data)) {
            $data = implode(',', $data);
        }
        $subject->getRequest()->setPostValue('selection_target', $data);

        return null;
    }
}
